"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.convertMilisecondsToDateString = exports.isDateStringValid = exports.constructLeaderboardId = exports.getMilisecondsToFinish = exports.getIdFromUTCTime = exports.getUTCTime = void 0;
function getUTCTime(date) {
    //return date.getTime() + date.getTimezoneOffset() * 60 * 1000;
    return date.getTime();
}
exports.getUTCTime = getUTCTime;
function getIdFromUTCTime(utcTime, challengeDurationMS, offset) {
    return Math.floor((utcTime + offset) / challengeDurationMS);
}
exports.getIdFromUTCTime = getIdFromUTCTime;
function getMilisecondsToFinish(utcStartTime, challengeDurationMS, challengeId, utcCurrentTime) {
    return challengeDurationMS * (challengeId + 1) + utcStartTime - utcCurrentTime;
}
exports.getMilisecondsToFinish = getMilisecondsToFinish;
function constructLeaderboardId(namePrefix, startDate, relativeIndex, durationOptionStr, scoreOrderingStr) {
    return "".concat(namePrefix, startDate, relativeIndex, durationOptionStr, scoreOrderingStr);
}
exports.constructLeaderboardId = constructLeaderboardId;
function isDateStringValid(dateString) {
    return !isNaN(Date.parse(dateString));
}
exports.isDateStringValid = isDateStringValid;
function convertMilisecondsToDateString(miliseconds) {
    if (miliseconds < 0) {
        return "";
    }
    const days = Math.floor(miliseconds / (24 * 60 * 60 * 1000));
    miliseconds = miliseconds % (24 * 60 * 60 * 1000);
    const hours = Math.floor(miliseconds / (60 * 60 * 1000));
    miliseconds = miliseconds % (60 * 60 * 1000);
    const minutes = Math.floor(miliseconds / (60 * 1000));
    return `${days}d ${hours}h ${minutes}m`;
}
exports.convertMilisecondsToDateString = convertMilisecondsToDateString;
//# sourceMappingURL=DateUtils.js.map